$OUTPUT_NAME:../src/message.h$
// SPDX-License-Identifier: CC0-1.0
/* ------------------------------------------------------------------------- */
/*!
 *  \file       message.h
 *  \brief      メッセージ
 *  \date       Since: June 29, 2021. 18:45:55 JST.
 *  \author     Acerola
 *  \version    1.0.1
 *  \note
 *      このヘッダはコンバータによって自動生成されています．
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MESSAGE_H_1624959955
#define INCGUARD_MESSAGE_H_1624959955

#include "mglext/message_holder.h"

namespace AppName
{

//! 言語ID
enum class LanguageID : uint32_t
{
    $LANGUAGE_LIST$
};

//! メッセージID
enum class MessageID : uint32_t
{
    $ID_LIST$
};
    
//! メッセージクラス
class Message
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     *  \param[in]  labelHash       ラベルのハッシュ値
     */
    /* ------------------------------------------------------------------------- */
    Message(uint32_t labelHash) noexcept
        : _index(MGLExt::MessageHolder::GetInstance().GetIndex(labelHash))
    {
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     *  \param[in]  label   メッセージラベル
     */
    /* ------------------------------------------------------------------------- */
    Message(MessageLabel label) noexcept
        : Message(static_cast<uint32_t>(label))
    {
    }
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     */
    /* ------------------------------------------------------------------------- */
    constexpr Message() noexcept
        : _index(SIZE_MAX)
    {
    }
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      メッセージを取得
     *  \return     メッセージの先頭アドレス
     */
    /* ------------------------------------------------------------------------- */
$IF:INDEXED$
    const MGL::Text::IndexedCharacter *Get() const noexcept
    {
        return MGLExt::MessageHolder::GetInstance().GetIndexedMessage(_index);
    }
$ELSE$ 
    const char *Get() const noexcept
    {
        return MGLExt::MessageHolder::GetInstance().GetMessage(_index);
    }
$ENDIF$

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      メッセージデータにキャスト
     *  \return     メッセージの先頭アドレス
     */
    /* ------------------------------------------------------------------------- */
    operator const auto () const noexcept
    {
        return Get();
    }
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      使用言語の設定
     *  \param[in]  language    使用言語
     *  \retval     true        成功
     *  \retval     false       失敗
     */
    /* ------------------------------------------------------------------------- */
    static bool SetLanguage(MGL::System::Language language) noexcept
    {
        return MGLExt::MessageHolder::GetInstance().SetLanguage(language);
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      bool型へのキャスト
     *  \retval     true    このメッセージが有効
     *  \retval     false   このメッセージは無効
     */
    /* ------------------------------------------------------------------------- */
    explicit operator bool() const noexcept
    {
        return _index < MGLExt::MessageHolder::GetInstance().GetLabelCount();
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      否定演算子
     *  \retval     true    このメッセージは無効
     *  \retval     false   このメッセージが有効
     */
    /* ------------------------------------------------------------------------- */
    bool operator!() const noexcept
    {
        return static_cast<bool>(*this);
    }
    
private:
    size_t _index;
};
}   // namespage AppName

#endif	// INCGUARD_MESSAGE_H_1624959955

// vim: et ts=4 sw=4 sts=4

