// SPDX-License-Identifier: CC0-1.0
/* ------------------------------------------------------------------------- */
/*!
 *  \file       win_main.cc
 *  \brief      MGL Windows用エントリポイント
 *  \date       Since: October 30, 2022. 15:01:35 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <app_main.h>

#include "Resource.h"

#include <mgl/mgl.h>
#include <mgl/platform/win32/mgl_win32_main.h>
#include <mgl/initialize/mgl_initializer_win32.h>

#include <Windows.h>

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      エントリポイント
 *  \param[in]  hInstance       アプリケーションインスタンス
 *  \param[in]  hPrevInstance   未使用
 *  \param[in]  lpCmdLine       コマンドラインオプション
 *  \param[in]  nCmdShow        ウィンドウの表示状態
 *  \return     終了コード
 */
/* ------------------------------------------------------------------------- */
int WINAPI WinMain(_In_ HINSTANCE hInstance, _In_opt_ HINSTANCE hPrevInstance, _In_ LPSTR lpCmdLine, _In_ int nCmdShow)
{
    MGL::Win32::Initializer initializer;

    /*
     *  ログレベルの設定
     *      通常は AppTrace のままで問題ありません．
     *      MGL側のトレースを表示したい場合は LibraryTrace に変更してください．
     */
    initializer.SetLogLevel(MGL::System::LogLevel::AppTrace);

    /*
     *  オーディオの初期化モード
     *      作るゲームにとって都合の良いモードを指定してください．
     *      オーディオ再生が不要な場合には None を指定できます．
     */
    initializer.SetAudioInitializeMode(MGL::Audio::InitializeMode::Sample44k2ch);

    /*
     *  XInput ゲームパッドの有効化
     *      不要な場合は false を指定してください．
     */
    initializer.EnableXInputGamepad(true);

    /*
     *  DirectInput ゲームパッドの有効化
     *      不要な場合は false を指定してください．
     *      この指定が true であっても，XInputゲームパッドが接続されている場合は
     *      DirectInputゲームパッドは利用できません．
     */
    initializer.EnableDirectInputGamepad(true);


    // ウィンドウの設定
    MGL::Win32::Window::Descriptor windowDescriptor;
    windowDescriptor.width = 1280;                                              // 幅
    windowDescriptor.height = 720;                                              // 高さ
    windowDescriptor.windowTitle = L"YourAppName";                              // ウィンドウタイトルに表示する文字列
    windowDescriptor.className = windowDescriptor.windowTitle;                  // ウィンドウのクラス名に設定する文字列
    windowDescriptor.icon = LoadIcon(hInstance, MAKEINTRESOURCE(IDC_MYICON));   // ウィンドウアイコン
    windowDescriptor.smallIcon = windowDescriptor.icon;                         // ウィンドウの小アイコン

    /*
     *   MGLのメイン関数の呼び出し
     *      テンプレート引数には登録するアプリケーションデリゲートのクラス名を記述してください．
     */
    auto result = MGL::Win32::Main<YourApp::Application>(hInstance, hPrevInstance, lpCmdLine, nCmdShow, initializer, windowDescriptor);

    return result;
}

// vim: et ts=4 sw=4 sts=4
