// SPDX-License-Identifier: CC0-1.0
/* ------------------------------------------------------------------------- */
/*!
 *  \file       AppDelegate.mm
 *  \brief      MGL tvOS用AppDelegate
 *  \date       Since: November 4, 2022. 16:31:56 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#import "AppDelegate.h"
#import <mgl/mgl.h>
#import <mgl/initialize/mgl_initializer_tvos.h>
#import "app_main.h"

@interface AppDelegate ()
@end

@implementation AppDelegate

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      アプリケーション起動後の処理
 *  \param[in]  launchOptions   起動オプション
 */
/* ------------------------------------------------------------------------- */
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    MGL::Apple::tvOS::Initializer initializer;
    
    /*
     *  ログレベルの設定
     *      通常は AppTrace のままで問題ありません．
     *      MGL側のトレースを表示したい場合は LibraryTrace に変更してください．
     */
    initializer.SetLogLevel(MGL::System::LogLevel::AppTrace);
    
    /*
     *  オーディオの初期化モード
     *      作るゲームにとって都合の良いモードを指定してください．
     *      オーディオ再生が不要な場合には None を指定できます．
     *      iOSでは1chのモードを使用することはできません．
     */
    initializer.SetAudioInitializeMode(MGL::Audio::InitializeMode::Sample44k2ch);

    /*
     *  GameControllerフレームワークによるキーボード入力の有効化
     *      不要な場合は false を指定してください．
     */
    initializer.EnableKeyboard(true);
    
    /*
     *  GameControllerフレームワークによるゲームパッドの有効化
     *      不要な場合は false を指定してください．
     */
    initializer.EnableGCGamepadDelegate(true);
    
    /*
     * MGLの初期化処理
     *      MGLのアプリケーションデリゲートのクラス名は適切なものに変更してください．
     */
    MGL::Initialize<YourApp::Application>(initializer);
    
    return YES;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      アプリケーション終了時の処理
 *  \param[in]  aNotification   イベント通知引数
 */
/* ------------------------------------------------------------------------- */
- (void)applicationWillTerminate:(NSNotification *)aNotification
{
    // MGLの終了処理
    MGL::Terminate();
}

@end

// vim: et ts=4 sw=4 sts=4
