// SPDX-License-Identifier: CC0-1.0
/* ------------------------------------------------------------------------- */
/*!
 *  \file       AppDelegate.mm
 *  \brief      MGL macOS用AppDelegate
 *  \date       Since: November 2, 2022. 12:41:12 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#import "AppDelegate.h"
#import <mgl/mgl.h>
#import "app_main.h"
#import <mgl/initialize/mgl_initializer_macos.h>

@interface AppDelegate ()

@property (strong) IBOutlet NSWindow *window;
@end

@implementation AppDelegate

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      アプリケーション起動後の処理
 *  \param[in]  aNotification   イベント通知引数
 */
/* ------------------------------------------------------------------------- */
- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    auto initializer = MGL::Apple::macOS::Initializer();
    
    /*
     *  ログレベルの設定
     *      通常は AppTrace のままで問題ありません．
     *      MGL側のトレースを表示したい場合は LibraryTrace に変更してください．
     */
    initializer.SetLogLevel(MGL::System::LogLevel::AppTrace);
    
    /*
     *  オーディオの初期化モード
     *      作るゲームにとって都合の良いモードを指定してください．
     *      オーディオ再生が不要な場合には None を指定できます．
     *      macOSでは1chのモードを使用することはできません．
     */
    initializer.SetAudioInitializeMode(MGL::Audio::InitializeMode::Sample44k2ch);
    
    /*
     *  GameControllerフレームワークによるキーボードデリゲートの有効化
     *      macOS 11.0 (Big Sur)以降で，キーボード入力にGameControllerフレームワークを使用するかの指定です．
     *      false を指定した場合，UIイベントによるキーボードデリゲートを使用します．
     */
    initializer.EnableGCKeyboardDelegate(true);

    /*
     *  GameControllerフレームワークによるゲームパッドの有効化
     *      不要な場合は false を指定してください．
     */
    initializer.EnableGCGamepadDelegate(true);

    /*
     *  IOKitによるHIDゲームパッドの有効化
     *      Appサンドボックスを有効にしている場合，USBデバイスへのアクセスを許可する必要があります．
     *      不要な場合は false を指定してください．
     */
    initializer.EnableIOKitGamepadDelegate(true);
    
    /*
     * MGLの初期化処理
     *      MGLのアプリケーションデリゲートのクラス名は適切なものに変更してください．
     */
    MGL::Initialize<YourApp::Application>(initializer);
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      アプリケーション終了時の処理
 *  \param[in]  aNotification   イベント通知引数
 */
/* ------------------------------------------------------------------------- */
- (void)applicationWillTerminate:(NSNotification *)aNotification
{
    // MGLの終了処理
    MGL::Terminate();
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      最後のウィンドウを閉じた際にアプリケーションを終了するかの取得
 *  \param[in]  theApplication  最後にウィンドウを閉じたアプリケーション
 *  \retval     YES             アプリケーションを終了する
 *  \retval     NO              アプリケーションを終了しない
 */
/* ------------------------------------------------------------------------- */
- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication
{
    return YES;
}

@end

// vim: et ts=4 sw=4 sts=4

