// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_task.cc
 *  \brief      MGL タスクシステム
 *  \date       Since: June 3, 2021. 11:55:39 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/task/mgl_task.h>

namespace MGL::Task
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      タスクシステムの初期化
 *  \param[in]  capacity        タスクの最大数
 *  \param[in]  descriptor      初期化用記述子
 *  \retval     true            成功
 *  \retval     false           失敗
 */
/* ------------------------------------------------------------------------- */
bool Initialize(size_t capacity, const InitializeDescriptor &descriptor) noexcept
{
    if (NodeList::HasInstance())
    {
        return false;
    }

    auto &nodeList = NodeList::CreateInstance();
    nodeList.Initialize(capacity, descriptor);

    return true;
}

}    // namespace MGL::Task

// vim: et ts=4 sw=4 sts=4
