// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_system_module_set.cc
 *  \brief      MGL システム関連モジュールセット
 *  \date       Since: July 17, 2022. 4:48:48 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/system/mgl_system_module_set.h>
#include <mgl/stl/mgl_stl_memory.h>

namespace MGL::System
{
namespace
{
STL::unique_ptr<ModuleSet> sInstance = nullptr; // インスタンス
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      インスタンスの取得
 *  \return     インスタンスの参照
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<ModuleSet> &ModuleSet::GetInstanceRef() noexcept
{
    return sInstance;
}
}  // namespace MGL::System

// vim: et ts=4 sw=4 sts=4
