// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_chrono_module_default.cc
 *  \brief      MGL デフォルトの日付と時間のモジュール
 *  \date       Since: February 24, 2021. 4:52:16 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/system/chrono/mgl_chrono_module_default.h>

#include <ctime>

#include <mgl/system/mgl_system_locale.h>

namespace MGL::System
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      現在時刻をエポック時間で取得
 *  \return     現在時刻
 */
/* ------------------------------------------------------------------------- */
EpochTime DefaultChronoModule::GetCurrentEpochTime() const noexcept
{
    return time(nullptr);
}
}    // namespace MGL::System

// vim: et ts=4 sw=4 sts=4
