// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_chrono_module_apple.mm
 *  \brief      MGL macOS/iOS/tvOS用の日付と時間のモジュール
 *  \date       Since: February 24, 2021. 5:35:53 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/system/chrono/mgl_chrono_module_apple.h>
#if defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)

#include <ctime>

#include <mach/mach_time.h>

#include <mgl/system/mgl_system_locale.h>


namespace MGL::System
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      コンストラクタ
 */
/* ------------------------------------------------------------------------- */
AppleChronoModule::AppleChronoModule() noexcept
{
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      現在のUNIXエポック時間を取得
 *  \return     現在のUNIXエポック時間
 */
/* ------------------------------------------------------------------------- */
EpochTime AppleChronoModule::GetCurrentEpochTime() const noexcept
{
    return time(nullptr);
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      Tickタイマーに対応しているかを取得
 *  \retval     true    対応している
 *  \retval     false   対応していない
 */
/* ------------------------------------------------------------------------- */
bool AppleChronoModule::IsAvailableTickTimer() const noexcept
{
    return true;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      現在のTickTimeを取得
 *  \return     現在のTickTime
 */
/* ------------------------------------------------------------------------- */
TickTime AppleChronoModule::GetTickTime() const noexcept
{
    return mach_absolute_time();
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      TickTimeをナノ秒に変換
 *  \return     変換後の時間
 */
/* ------------------------------------------------------------------------- */
float AppleChronoModule::TicksToNanoseconds(TickTime tickTime) const noexcept
{
    mach_timebase_info_data_t base;
    mach_timebase_info(&base);

    return tickTime * (base.numer / base.denom);
}

}    // namespace MGL::System

#endif    // defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)

// vim: et ts=4 sw=4 sts=4
