// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_application_module_uikit.mm
 *  \brief      MGL iOS/tvOS用アプリケーションモジュール
 *  \date       Since: February 25, 2021. 10:42:57 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/system/application/mgl_application_module_uikit.h>
#if defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)

#include <UIKit/UIKit.h>

namespace MGL::System
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      コンストラクタ
 */
/* ------------------------------------------------------------------------- */
UIKitApplicationModule::UIKitApplicationModule() noexcept
    : _argumentArray()
{
    // 実行引数を取得
    for (const NSString *touch in NSProcessInfo.processInfo.arguments)
    {
        _argumentArray.push_back(touch.UTF8String);
    }
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      スリープの抑制
 *  \param[in]  isEnabled   有効フラグ
 *  \retval     true        成功
 *  \retval     false       失敗
 */
/* ------------------------------------------------------------------------- */
bool UIKitApplicationModule::Caffeinate(bool isEnabled) noexcept
{
    UIApplication.sharedApplication.idleTimerDisabled = isEnabled;

    return true;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      スリープの抑制状態を取得
 *  \retval     true    有効
 *  \retval     false   無効
 */
/* ------------------------------------------------------------------------- */
bool UIKitApplicationModule::IsCaffeinated() const noexcept
{
    return UIApplication.sharedApplication.isIdleTimerDisabled;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      実行引数を取得
 *  \return     実行引数の配列
 */
/* ------------------------------------------------------------------------- */
const ArgumentArray &UIKitApplicationModule::GetArguments() const noexcept
{
    return _argumentArray;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      アプリケーションの終了
 */
/* ------------------------------------------------------------------------- */
void UIKitApplicationModule::Quit() noexcept
{
}

}    // namespace MGL::System

#endif    // defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)

// vim: et ts=4 sw=4 sts=4
