// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_renderer_set.cc
 *  \brief      MGL レンダラセット
 *  \date       Since: July 17, 2022. 5:29:23 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/render/mgl_renderer_set.h>

namespace MGL::Render
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      インスタンスの取得
 *  \return     インスタンスの参照
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<RendererSet> &RendererSet::GetInstanceRef() noexcept
{
    static STL::unique_ptr<RendererSet> sInstance = nullptr;
    return sInstance;
}
}    // namespace MGL::Render

// vim: et ts=4 sw=4 sts=4
