// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       line_shader.metal
 *  \brief      Metal用ラインシェーダ
 *  \date       Since: November 4, 2020. 14:57:55 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <metal_stdlib>
#include <mgl/render/metal/shader/mgl_metal_shader_types.h>

//! ラスタライザデータ
struct RasterizerData
{
    float4 position [[position]];   //!< 位置
    float4 color;                   //!< 色
};


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ライン用頂点シェーダ
 *  \param[in]  vertexID            頂点ID
 *  \param[in]  vertices            頂点情報
 *  \param[in]  projectionMatrix    平行投影行列
 *  \return     ラスタライズ後の頂点
 */
/* ------------------------------------------------------------------------- */
vertex RasterizerData lineVertexShader(
            uint vertexID [[vertex_id]],
            constant LineShaderVertex *vertices [[buffer(kLineShaderInputVertices)]],
            constant metal::float4x4 &projectionMatrix [[buffer(kLineShaderInputProjectionMatrix)]])
{
    RasterizerData out;
    
    out.position = projectionMatrix * float4(vertices[vertexID].position.xy, 0, 1);
    out.color = vertices[vertexID].color;
    
    return out;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ライン用フラグメントシェーダ
 *  \param[in]  in      ラスタライズ後の頂点情報
 *  \return     出力する色
 */
/* ------------------------------------------------------------------------- */
fragment float4 lineFragmentShader(RasterizerData in [[stage_in]])
{
    return in.color;
}

// vim: et ts=4 sw=4 sts=4 ft=cpp
