/* ------------------------------------------------------------------------- */
/*!
 *  \file       rectangle.hlsl
 *  \brief      `pVF[_
 *  \date       Since: November 18, 2019. 11:18:22 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

//! ϊs
cbuffer CBViewMatrix : register(b0)
{
    matrix view;    //!< r[s
};

//! `Agr[g
struct Attribute
{
    float4 offset;      //!< ItZbgixŷݎgpj
    float4 scale;       //!< XP[ixŷݎgpj
    float4 color;       //!< F
    float  rotate;      //!< ]px
    float2 pivot;       //!< ]s{bg
    float  unused;      //!< gp
};

//! Agr[gp萔obt@
cbuffer CBAttribute : register(b1)
{
    Attribute attribute[ATTRIBUTE_SIZE];
};

//! _VF[_̓
struct VS_INPUT
{
    float2 position : POSITION;
};

//! sNZVF[_̓
struct PS_INPUT
{
    float4 position : SV_POSITION;
    float4 color : COLOR;
};


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      _VF[_
 */
/* ------------------------------------------------------------------------- */
PS_INPUT VS_FUNCTION(VS_INPUT input, uint instID : SV_InstanceID)
{
    PS_INPUT output = (PS_INPUT)0;
    Attribute attr = attribute[instID];

    float4x4 trMatrix =
    {
        cos(attr.rotate), sin(-attr.rotate), 0.0f, 0.0f,
        sin(attr.rotate), cos(attr.rotate), 0.0f, 0.0f,
        0.0f, 0.0f, 1.0f, 0.0f,
        attr.offset.x, attr.offset.y, 0.0f, 1.0f
    };

    output.position = mul(view, mul(float4(
                                        (input.position.x - attr.pivot.x) * attr.scale.x,
                                        (input.position.y - attr.pivot.y) * attr.scale.y,
                                        0.0f,
                                        1.0f), trMatrix));
    output.color = attr.color;

    return output;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      sNZVF[_
 */
/* ------------------------------------------------------------------------- */
float4 PS(PS_INPUT input) : SV_Target
{
    return input.color;
}

// vim: et ts=4 sw=4 sts=4
