/* ------------------------------------------------------------------------- */
/*!
 *  \file       line.hlsl
 *  \brief      ライン用シェーダ
 *  \date       Since: April 3, 2021. 15:21:03 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

//! 変換行列
cbuffer CBViewMatrix : register(b0)
{
    matrix view;    //!< ビュー行列
};

//! 頂点シェーダの入力
struct VS_INPUT
{
    float2 position : POSITION;
    float4 color : COLOR;
};

//! ピクセルシェーダの入力
struct PS_INPUT
{
    float4 position : SV_POSITION;
    float4 color : COLOR;
};


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      頂点シェーダ
 */
/* ------------------------------------------------------------------------- */
PS_INPUT VS(VS_INPUT input)
{
    PS_INPUT output = (PS_INPUT)0;

    output.position = mul(view, float4(input.position.x, input.position.y, 0.0f, 1.0f));
    output.color = input.color;

    return output;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ピクセルシェーダ
 */
/* ------------------------------------------------------------------------- */
float4 PS(PS_INPUT input) : SV_Target
{
    return input.color;
}

// vim: et ts=4 sw=4 sts=4
