#/usr/bin/env sh

BUFFER_MAX=1024
BUFFER_MIN=1

# 頂点シェーダのコンパイル
function compile_vs()
{
    mkdir -p $1

    size=${BUFFER_MAX}
    while [ ${size} -ge ${BUFFER_MIN} ]
    do
        fxc $1.hlsl /nologo /T vs_4_0 /Fh $1/$1_vs_${size}.h /E VS_${size} /D ATTRIBUTE_SIZE=${size} /D VS_FUNCTION=VS_${size}
        if [ $? -ne 0 ]; then
            return 1
        fi
        size=`expr ${size} / 2`
    done

    return 0
}

# ピクセルシェーダのコンパイル
function compile_ps()
{
    fxc $1.hlsl /nologo /T ps_4_0 /Fh $1/$1_ps.h /E PS /D ATTRIBUTE_SIZE=${BUFFER_MAX} /D VS_FUNCTION=VS
    if [ $? -ne 0 ]; then
        return 1
    fi

    return 0
}

# ヘッダの生成
function make_header()
{
    file=`echo $1.h`
    echo "// $1.h (auto generated)" > ${file}

    size=${BUFFER_MAX}
    while [ ${size} -ge ${BUFFER_MIN} ]
    do
        echo "#include \"$1/$1_vs_${size}.h\"" >> ${file}
        size=`expr ${size} / 2`
    done
    echo "#include \"$1/$1_ps.h\"" >> ${file}
    echo "" >> ${file}

    echo "struct VSTable_$1" >> ${file}
    echo "{" >> ${file}
    echo "    int attributeSize;" >> ${file}
    echo "    const BYTE *binary;" >> ${file}
    echo "    size_t binarySize;" >> ${file}
    echo "};" >> ${file}
    echo "" >> ${file}

    echo "static const VSTable_$1 s_VS_$1[] =" >> ${file}
    echo "{" >> ${file}
    size=${BUFFER_MAX}
    while [ ${size} -ge ${BUFFER_MIN} ]
    do
        echo "    { ${size}, g_VS_${size}, sizeof(g_VS_${size}) }," >> ${file}
        size=`expr ${size} / 2`
    done
    echo "};" >> ${file}
    echo "" >> ${file}

    return 0
}


compile_vs $1
if [ $? -ne 0 ]; then
    exit 1;
fi

compile_ps $1
if [ $? -ne 0 ]; then
    exit 1;
fi

make_header $1

exit 0
