// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_d3d11_texture_generator.cc
 *  \brief      MGL Direct3D11用テクスチャジェネレータ
 *  \date       Since: March 27, 2021. 3:46:16 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/render/d3d11/mgl_d3d11_texture_generator.h>
#if defined(MGL_RENDERER_ENABLE_D3D11)

#include <mgl/render/d3d11/mgl_d3d11_texture_resource.h>
#include <mgl/stl/mgl_stl_memory.h>

namespace MGL::Render::D3D11
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      テクスチャリソースの生成
 *  \return     生成されたテクスチャリソース
 */
/* ------------------------------------------------------------------------- */
SharedTextureResource TextureGenerator::MakeTextureResource() noexcept
{
    return STL::make_shared<TextureResource>();
}
}   // namespace MGL::Render::D3D11

#endif  // MGL_RENDERER_ENABLE_D3D11

// vim: et ts=4 sw=4 sts=4
