// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_tvos_view_controller.mm
 *  \brief      MGL tvOS用ビューコントローラ
 *  \date       Since: February 27, 2021. 12:14:34 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */
#import <mgl/platform/apple/tvos/mgl_tvos_view_controller.h>

#if defined(MGL_TARGET_TVOS)

#import <MetalKit/MetalKit.h>
#import <mgl/render/metal/mgl_metal_renderer.h>
#import <mgl/event/mgl_event.h>
#import <mgl/mgl.h>
#import <mgl/platform/apple/tvos/mgl_tvos_notification_observer.h>

@implementation MGLtvOSViewController
{
    MGLtvOSNotificationObserver *_observer;
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ビュー読み込み後の処理
 */
/* ------------------------------------------------------------------------- */
- (void)viewDidLoad
{
    [super viewDidLoad];
 
    // コントローラをレスポンダーチェーンで処理させないよう要求
    self.controllerUserInteractionEnabled = NO;
    
    // イベント通知を登録
    _observer = [MGLtvOSNotificationObserver new];
}

@end
#endif  // MGL_TARGET_TVOS

// vim: et ts=4 sw=4 sts=4
