// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_apple_metal_view_controller.mm
 *  \brief      Metalビューコントローラ
 *  \date       Since: November 3, 2020. 17:10:56 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#import <mgl/platform/apple/mgl_apple_metal_view_controller.h>
#import <mgl/render/metal/mgl_metal_renderer.h>
#import <mgl/event/mgl_event.h>
#import <mgl/mgl.h>

//! Metalビューコントローラクラス
@implementation MGLMetalViewController
{
    MTKView *_view;
    MGLMetalRenderer *_renderer;    //!< Metal用レンダラ
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ビュー読み込み後の処理
 */
/* ------------------------------------------------------------------------- */
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    // Metalデバイスの生成
    _view = (MTKView *)self.view;
    _view.device = MTLCreateSystemDefaultDevice();
    if (_view.device == nil)
    {
        NSLog(@"[Renderer] Metal is not supported on this device.");
        return;
    }
    
    // レンダラの生成
    _renderer = [[MGLMetalRenderer alloc] initWithMetalKitView:_view];
    if (_renderer == nil)
    {
        NSLog(@"[Renderer] Failed to initialize renderer.");
        return;
    }
    _view.delegate = _renderer;

    // 現在のビューのサイズをレンダラに伝える
    [_renderer mtkView:_view drawableSizeWillChange:_view.drawableSize];
    
    // MGLが初期化済みであればレンダラが初期化された事を通知する
    if (MGL::Event::Notifier::HasInstance())
    {
        MGL::Event::Notify(MGL::Event::NotifyType::DidInitializableRenderer);
    }
}

@end

// vim: et ts=4 sw=4 sts=4
