// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_macos_static_info.mm
 *  \brief      MGL macOSのMGL初期化前に取得可能な情報
 *  \date       Since: July 10, 2022. 3:59:20 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/platform/apple/macos/mgl_macos_static_info.h>

#if defined(MGL_TARGET_MACOS)

#import <Foundation/Foundation.h>
#import <mgl/platform/apple/macos/mgl_macos_view_controller.h>

namespace MGL::Platform::MacOS
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      実行ファイルのパスを取得
 *  \param[in]  isDirectoryOnly     trueでディレクトリのパスのみを取得
 *  \return     実行ファイルのパス
 */
/* ------------------------------------------------------------------------- */
std::string GetExecutablePath(bool isDirectoryOnly) noexcept
{
    NSBundle *mainBundle = NSBundle.mainBundle;
    NSString *executablePath = mainBundle.executablePath;
    
    if (isDirectoryOnly)
    {
        return std::string(executablePath.stringByDeletingLastPathComponent.UTF8String);
    }

    return std::string(executablePath.UTF8String);
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      フレームワークのあるパスを取得
 *  \return     フレームワークのあるパス
 */
/* ------------------------------------------------------------------------- */
std::string GetFrameworkPath() noexcept
{
    NSBundle *mainBundle = NSBundle.mainBundle;
    NSString *frameworkPath = mainBundle.privateFrameworksPath;

    return std::string(frameworkPath.UTF8String);
}
}   // namespage MGL::Platform::MacOS

#endif  // MGL_TARGET_MACOS

// vim: et ts=4 sw=4 sts=4
