// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_ios_notification_observer.mm
 *  \brief      MGL iOS用システム通知受信クラス
 *  \date       Since: February 18, 2021. 4:04:23 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#import <mgl/platform/apple/ios/mgl_ios_notification_observer.h>
#if defined(MGL_TARGET_IOS)

#import <mgl/event/mgl_event.h>
#import <AVFoundation/AVFoundation.h>

@implementation MGLiOSNotificationObserver

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      初期化処理
 */
/* ------------------------------------------------------------------------- */
- (id)init
{
    NSNotificationCenter *notificationCenter = [NSNotificationCenter defaultCenter];
        
    // オーディオセッションの停止と再開
    [notificationCenter addObserver:self
                           selector:@selector(audioSessionInterruptionObserver:)
                               name:@"AVAudioSessionInterruptionNotification"
                             object:nil];
    
    // アプリケーションの中断コールバック
    [notificationCenter addObserver:self
                           selector:@selector(applicationWillResignActiveObserver:)
                               name:@"UIApplicationWillResignActiveNotification"
                             object:nil];

    return self;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      オーディオの中断と再開
 */
/* ------------------------------------------------------------------------- */
- (void)audioSessionInterruptionObserver:(NSNotification *)notification
{
    NSNumber *interruptType = [notification.userInfo objectForKey:@"AVAudioSessionInterruptionTypeKey"];
    
    // 中断
    if ([interruptType unsignedIntegerValue] == AVAudioSessionInterruptionTypeBegan)
    {
        MGL::Event::Notify(MGL::Event::NotifyType::AudioSuspend);
    }
    // 再開
    else if ([interruptType unsignedIntegerValue] == AVAudioSessionInterruptionTypeEnded)
    {
        MGL::Event::Notify(MGL::Event::NotifyType::AudioResume);
    }
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      アプリケーションの中断
 */
/* ------------------------------------------------------------------------- */
- (void)applicationWillResignActiveObserver:(NSNotification *)notification
{
    MGL::Event::Notify(MGL::Event::NotifyType::AppSuspend);
}

@end

#endif // MGL_TARGET_IOS

// vim: et ts=4 sw=4 sts=4
