// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_application_delegate.cc
 *  \brief      MGLアプリケーションデリゲートクラス
 *  \date       Since: November 28, 2020. 19:23:54 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/mgl_application_delegate.h>
#include <mgl/initialize/mgl_initialize.h>

namespace MGL
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      コンストラクタ
 */
/* ------------------------------------------------------------------------- */
ApplicationDelegate::ApplicationDelegate() noexcept
    : _eventAppInitialize(Event::NotifyType::AppInitialize, OnEventAppInitialize, this)
    , _eventAppFrameUpdate(Event::NotifyType::AppFrameUpdate, OnEventAppFrameUpdate, this)
    , _eventAppExit(Event::NotifyType::AppExit, OnEventAppExit, this)
{
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      初期化処理
 *  \retval     true    成功
 *  \retval     false   失敗
 */
/* ------------------------------------------------------------------------- */
bool ApplicationDelegate::Initialize() noexcept
{
    if (!MGL::IsInitialized())
    {
        return false;
    }

    _isAvailable = OnInitialize();
    
    return _isAvailable;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      初期化処理
 *  \param[in]  callbackArg     このクラスのアドレス
 *  \param[in]  notifyArg       未使用
 */
/* ------------------------------------------------------------------------- */
void ApplicationDelegate::OnEventAppInitialize(void *callbackArg, [[maybe_unused]] void *notifyArg) noexcept
{
    auto *thisPtr = static_cast<ApplicationDelegate *>(callbackArg);
    
    thisPtr->Initialize();
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      フレーム更新処理の呼び出し
 *  \param[in]  callbackArg     このクラスのアドレス
 *  \param[in]  notifyArg       未使用
 */
/* ------------------------------------------------------------------------- */
void ApplicationDelegate::OnEventAppFrameUpdate(void *callbackArg, [[maybe_unused]] void *notifyArg) noexcept
{
    auto *thisPtr = static_cast<ApplicationDelegate *>(callbackArg);
    
    if (thisPtr->_isAvailable)
    {
        thisPtr->OnFrameUpdate();
    }
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      終了処理の呼び出し
 *  \param[in]  callbackArg     このクラスのアドレス
 *  \param[in]  notifyArg       未使用
 */
/* ------------------------------------------------------------------------- */
void ApplicationDelegate::OnEventAppExit(void *callbackArg, [[maybe_unused]] void *notifyArg) noexcept
{
    auto *thisPtr = static_cast<ApplicationDelegate *>(callbackArg);
    
    if (thisPtr->_isAvailable)
    {
        thisPtr->OnExit();
        thisPtr->_isAvailable = false;
    }
}

}   // namespace MGL

// vim: et ts=4 sw=4 sts=4
