// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_initializer_delegate.cc
 *  \brief      MGL イニシャライザデリゲート
 *  \date       Since: March 18, 2021. 18:14:56 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/initialize/mgl_initializer_delegate.h>

#include <mgl/audio/renderer/mgl_audio_renderer.h>
#include <mgl/input/keyboard/mgl_keyboard_delegate.h>
#include <mgl/input/mouse/mgl_mouse_delegate.h>
#include <mgl/input/touch/mgl_touch_delegate.h>
#include <mgl/render/mgl_renderer_2d_delegate.h>
#include <mgl/render/mgl_texture_generator.h>
#include <mgl/system/application/mgl_application_module_default.h>
#include <mgl/system/chrono/mgl_chrono_module_default.h>
#include <mgl/system/debug/mgl_debug_module_default.h>
#include <mgl/system/locale/mgl_locale_module_default.h>
#include <mgl/system/window/mgl_window_module_default.h>

namespace MGL
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      2Dレンダラを生成
 *  \return     2Dレンダラ
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<Render::Renderer2DDelegate> InitializerDelegate::MakeRenderer2D() const noexcept
{
    return nullptr;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      テクスチャジェネレータを生成
 *  \return     テクスチャジェネレータ
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<Render::TextureGenerator> InitializerDelegate::MakeTextureGenerator() const noexcept
{
    return nullptr;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      オーディオレンダラの生成
 *  \return     オーディオレンダラ
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<Audio::Renderer> InitializerDelegate::MakeAudioRenderer() const noexcept
{
    return nullptr;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      アプリケーションモジュールの生成
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<System::ApplicationModuleInterface> InitializerDelegate::MakeApplicationModule() const noexcept
{
    return STL::make_unique<System::DefaultApplicationModule>();
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      日付と時刻のモジュールを生成
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<System::ChronoModuleInterface> InitializerDelegate::MakeChronoModule() const noexcept
{
    return STL::make_unique<System::DefaultChronoModule>();
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      デバッグモジュールを生成
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<System::DebugModuleInterface> InitializerDelegate::MakeDebugModule() const noexcept
{
    return STL::make_unique<System::DefaultDebugModule>(_logLevel);
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ロケール情報モジュールを生成
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<System::LocaleModuleInterface> InitializerDelegate::MakeLocaleModule() const noexcept
{
    return STL::make_unique<System::DefaultLocaleModule>();
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ウィンドウモジュールを生成
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<System::WindowModuleInterface> InitializerDelegate::MakeWindowModule() const noexcept
{
    return STL::make_unique<System::DefaultWindowModule>();
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      キーボード入力デリゲートの生成
 *  \return     キーボード入力デリゲート
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<Input::KeyboardDelegate> InitializerDelegate::MakeKeyboardDelegate() const noexcept
{
    return nullptr;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      マウス入力デリゲートの生成
 *  \return     マウス入力デリゲート
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<Input::MouseDelegate> InitializerDelegate::MakeMouseDelegate() const noexcept
{
    return nullptr;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      タッチ入力デリゲートの生成
 *  \return     タッチ入力デリゲート
 */
/* ------------------------------------------------------------------------- */
STL::unique_ptr<Input::TouchDelegate> InitializerDelegate::MakeTouchDelegate() const noexcept
{
    return nullptr;
}
}    // namespace MGL

// vim: et ts=4 sw=4 sts=4
