// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_file_access_work.cc
 *  \brief      ファイルアクセスのための作業用クラス
 *  \date       Since: January 22, 2021. 9:38:11 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/file/mgl_file_access_work.h>
#include <mgl/file/mgl_file_delegate.h>

namespace MGL::File
{

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      コンストラクタ
 *  \param[in]  mode    オープンモード
 *  \param[in]  key     デリゲートキー
 */
/* ------------------------------------------------------------------------- */
AccessWork::AccessWork(OpenMode mode, DelegateKey key) noexcept
    : _mode(mode)
    , _key(key)
    , _delegate(nullptr)
{
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief  このワークをクローズ
 */
/* ------------------------------------------------------------------------- */
void AccessWork::Close() noexcept
{
    if (IsOpen())
    {
        if (_delegate != nullptr)
        {
            _delegate->Close(this);

            _delegate.reset();
            _key = DelegateKey{0};
            _mode = OpenMode::None;
        }
    }
}

}    // namespace MGL::File

// vim: et ts=4 sw=4 sts=4
