// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_event_handle.cc
 *  \brief      MGL イベントハンドル
 *  \date       Since: December 23, 2020. 13:29:35 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/event/mgl_event_handle.h>
#include <mgl/event/mgl_event_notifier.h>

namespace MGL::Event
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      コンストラクタ
 */
/* ------------------------------------------------------------------------- */
Handle::Handle() noexcept
    : _type(NotifyType::Reserve_Invalid)
    , _id(0)
{
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      コンストラクタ
 *  \param[in]  type        通知タイプ
 *  \param[in]  callback    コールバック関数
 *  \param[in]  callbackArg コールバック関数の引数
 */
/* ------------------------------------------------------------------------- */
Handle::Handle(NotifyType type, CallbackFunction callback, void *callbackArg) noexcept
    : _type(NotifyType::Reserve_Invalid)
    , _id(0)
{
    Notifier::GetInstance().Register(*this, type, callback, callbackArg);
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      デストラクタ
 */
/* ------------------------------------------------------------------------- */
Handle::~Handle() noexcept
{
    Unregister();
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      パラメータの設定
 *  \param[in]  type    通知タイプ
 *  \param[in]  id      通知ID
 */
/* ------------------------------------------------------------------------- */
void Handle::Set(NotifyType type, UniqueID id) noexcept
{
    _type = type;
    _id = id;
}


/* ------------------------------------------------------------------------- */
/*!
 *  \brief      登録解除
 */
/* ------------------------------------------------------------------------- */
void Handle::Unregister() noexcept
{
    if ((_type == NotifyType::Reserve_Invalid) || (_id == 0))
    {
        return;
    }

    if (Notifier::HasInstance())
    {
        Notifier::GetInstance().Unregister(*this);
    }
}

}    // namespace MGL::Event

// vim: et ts=4 sw=4 sts=4
