/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_color_xterm.cc
 *  \brief      MGL xterm-256カラー定義
 *  \date       Since: April 30, 2023. 23:42:14 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/common/mgl_color_xterm.h>

namespace MGL
{
namespace
{
//! 名前のハッシュ値テーブル
constexpr uint32_t kNameHashTable[] =
{
    0x0053D7F2, 0x0153D985, 0x0BB4FC40, 0x0C4F6DA8, 0x0CB4FDD3, 0x0D4F6F3B, 0x0DB4FF66, 0x0DC409F0,
    0x0EB500F9, 0x0EC40B83, 0x0FB5028C, 0x0FC40D16, 0x104F73F4, 0x10526D3E, 0x10B5041F, 0x10C40EA9,
    0x10C64D40, 0x114F7587, 0x1151B41E, 0x11C64ED3, 0x124F771A, 0x1251B5B1, 0x134F78AD, 0x1351B744,
    0x13C41362, 0x1451B8D7, 0x14C414F5, 0x14C6538C, 0x1551BA6A, 0x159F7924, 0x15C6551F, 0x1651BBFD,
    0x16C656B2, 0x16F64B0C, 0x17C65845, 0x17F64C9F, 0x1AF65158, 0x1BF652EB, 0x1CF6547E, 0x1DF65611,
    0x1EF657A4, 0x1FF65937, 0x20681F30, 0x20F65ACA, 0x216820C3, 0x21F65C5D, 0x22682256, 0x236823E9,
    0x236A6280, 0x2468257C, 0x246A6413, 0x2568270F, 0x276A68CC, 0x286A6A5F, 0x296A6BF2, 0x2A6A6D85,
    0x359D6970, 0x369D6B03, 0x376604CE, 0x3796F14B, 0x38660661, 0x396607F4, 0x399D6FBC, 0x3A660987,
    0x3A9D714F, 0x3A9FAFE6, 0x3B660B1A, 0x3B9D72E2, 0x3B9FB179, 0x3C660CAD, 0x3C9D7475, 0x3C9FB30C,
    0x3D9FB49F, 0x3E34D0A2, 0x3E9FB632, 0x3F9FB7C5, 0x45D2FF89, 0x460B6190, 0x470B6323, 0x480B64B6,
    0x490B6649, 0x490DA4E0, 0x4A0B67DC, 0x4A0DA673, 0x4B0B696F, 0x4D0DAB2C, 0x4E0DACBF, 0x4E0FEB56,
    0x4F0DAE52, 0x4F0FECE9, 0x500DAFE5, 0x500FEE7C, 0x510FF00F, 0x520FF1A2, 0x530FF335, 0x5A6ED2A0,
    0x5B6ED433, 0x5C6ED5C6, 0x5D4EA8A6, 0x5D6ED759, 0x5D7115F0, 0x5E711783, 0x606EDC12, 0x616EDDA5,
    0x61711C3C, 0x617C1B25, 0x62711DCF, 0x63711F62, 0x647120F5, 0x68384781, 0x78458A50, 0x79458BE3,
    0x7A458D76, 0x7B458F09, 0x7B47CDA0, 0x7C45909C, 0x7C47CF33, 0x7D45922F, 0x7D47D0C6, 0x7D56DB50,
    0x7E47D259, 0x7E56DCE3, 0x8147D712, 0x8156E19C, 0x8247D8A5, 0x8256E32F, 0x8356E4C2, 0x8456E655,
    0x865E9A30, 0x875E9BC3, 0x885E9D56, 0x895E9EE9, 0x8A5EA07C, 0x8B5EA20F, 0x8C5EA3A2, 0x8D5EA535,
    0x8EB80910, 0x8FB80AA3, 0x8FFDC54C, 0x90B80C36, 0x90FDC6DF, 0x91B80DC9, 0x91FDC872, 0x925EAD14,
    0x92FDCA05, 0x935EAEA7, 0x9363A489, 0x93BA4F86, 0x94B81282, 0x94BA5119, 0x95B81415, 0x95BA52AC,
    0x96BA543F, 0x97BA55D2, 0x98BA5765, 0x9CBC9C48, 0x9DBC9DDB, 0x9EBC9F6E, 0x9FBCA101, 0xA0BCA294,
    0xA1BCA427, 0xA5DF1F7F, 0xA86D7276, 0xA96D7409, 0xAA6D759C, 0xAB6D772F, 0xAC6D78C2, 0xAD6D7A55,
    0xAE8E7E19, 0xB16FBF38, 0xB26FC0CB, 0xB36FC25E, 0xB46FC3F1, 0xB4720288, 0xB572041B, 0xB76FC8AA,
    0xB86FCA3D, 0xB87208D4, 0xB9720A67, 0xBA720BFA, 0xBB720D8D, 0xBDB5C215, 0xBE591506, 0xC193B878,
    0xC293BA0B, 0xC393BB9E, 0xC3A2C628, 0xC493BD31, 0xC495FBC8, 0xC4A2C7BB, 0xC593BEC4, 0xC595FD5B,
    0xC5A2C94E, 0xC693C057, 0xC695FEEE, 0xC6A2CAE1, 0xC6A50978, 0xC7960081, 0xC7A50B0B, 0xC9A2CF9A,
    0xCA96053A, 0xCAA2D12D, 0xCAA50FC4, 0xCB9606CD, 0xCBA51157, 0xCCA512EA, 0xCDA5147D, 0xD503F3E8,
    0xD603F57B, 0xD703F70E, 0xD803F8A1, 0xD8063738, 0xD903FA34, 0xD90638CB, 0xDA03FBC7, 0xDA063A5E,
    0xDB063BF1, 0xDD087DAE, 0xDE0640AA, 0xDE087F41, 0xDF06423D, 0xDF0880D4, 0xE0088267, 0xE0651836,
    0xE10883FA, 0xE16519C9, 0xE208858D, 0xE2651B5C, 0xE3651CEF, 0xE4651E82, 0xE5652015, 0xE96764F8,
    0xEA67668B, 0xEB67681E, 0xEC6769B1, 0xEC69A848, 0xED676B44, 0xED69A9DB, 0xEE676CD7, 0xF069AE94,
    0xF12BDE0B, 0xF169B027, 0xF16BEEBE, 0xF269B1BA, 0xF26BF051, 0xF369B34D, 0xF36BF1E4, 0xF46BF377,
    0xF56BF50A, 0xF66BF69D, 0xF9BC55FD, 0xFA53CE80, 0xFB53D013, 0xFB7FC03C, 0xFC53D1A6, 0xFD53D339,
};


//! 名前のハッシュ値テーブルに対応した色テーブル
constexpr XColor kNameHashColorTable[] =
{
    XColor::C034,    XColor::C035,   XColor::C120,   XColor::C014,   XColor::C121,   XColor::C015,   XColor::C122,   XColor::C142,
    XColor::C123,    XColor::C143,   XColor::C124,   XColor::C140,   XColor::C010,   XColor::Maroon, XColor::C125,   XColor::C141,
    XColor::C155,    XColor::C011,   XColor::C005,   XColor::C154,   XColor::C012,   XColor::C004,   XColor::C013,   XColor::C003,
    XColor::C144,    XColor::C002,   XColor::C145,   XColor::C151,   XColor::C001,   XColor::Teal,   XColor::C150,   XColor::C000,
    XColor::C153,    XColor::Gray18, XColor::C152,   XColor::Gray19, XColor::Gray14, XColor::Gray15, XColor::Gray16, XColor::Gray17,
    XColor::Gray10,  XColor::Gray11, XColor::C241,   XColor::Gray12, XColor::C240,   XColor::Gray13, XColor::C243,   XColor::C242,
    XColor::C234,    XColor::C245,   XColor::C235,   XColor::C244,   XColor::C230,   XColor::C231,   XColor::C232,   XColor::C233,
    XColor::C304,    XColor::C305,   XColor::C254,   XColor::Silver, XColor::C255,   XColor::C252,   XColor::C300,   XColor::C253,
    XColor::C301,    XColor::C315,   XColor::C250,   XColor::C302,   XColor::C314,   XColor::C251,   XColor::C303,   XColor::C313,
    XColor::C312,    XColor::Navy,   XColor::C311,   XColor::C310,   XColor::Black,  XColor::C421,   XColor::C420,   XColor::C423,
    XColor::C422,    XColor::C454,   XColor::C425,   XColor::C455,   XColor::C424,   XColor::C450,   XColor::C451,   XColor::C445,
    XColor::C452,    XColor::C444,   XColor::C453,   XColor::C443,   XColor::C442,   XColor::C441,   XColor::C440,   XColor::C502,
    XColor::C503,    XColor::C500,   XColor::Blue,   XColor::C501,   XColor::C515,   XColor::C514,   XColor::C504,   XColor::C505,
    XColor::C511,    XColor::Gray,   XColor::C510,   XColor::C513,   XColor::C512,   XColor::Olive,  XColor::C050,   XColor::C051,
    XColor::C052,    XColor::C053,   XColor::C043,   XColor::C054,   XColor::C042,   XColor::C055,   XColor::C041,   XColor::C025,
    XColor::C040,    XColor::C024,   XColor::C045,   XColor::C021,   XColor::C044,   XColor::C020,   XColor::C023,   XColor::C022,
    XColor::Gray5,   XColor::Gray4,  XColor::Gray7,  XColor::Gray6,  XColor::Gray1,  XColor::Gray0,  XColor::Gray3,  XColor::Gray2,
    XColor::C133,    XColor::C132,   XColor::Gray21, XColor::C131,   XColor::Gray20, XColor::C130,   XColor::Gray23, XColor::Gray9,
    XColor::Gray22,  XColor::Gray8,  XColor::Green,  XColor::C104,   XColor::C135,   XColor::C105,   XColor::C134,   XColor::C102,
    XColor::C103,    XColor::C100,   XColor::C101,   XColor::C111,   XColor::C110,   XColor::C113,   XColor::C112,   XColor::C115,
    XColor::C114,    XColor::Lime,   XColor::C225,   XColor::C224,   XColor::C223,   XColor::C222,   XColor::C221,   XColor::C220,
    XColor::Magenta, XColor::C212,   XColor::C213,   XColor::C210,   XColor::C211,   XColor::C205,   XColor::C204,   XColor::C214,
    XColor::C215,    XColor::C201,   XColor::C200,   XColor::C203,   XColor::C202,   XColor::Red,    XColor::Yellow, XColor::C340,
    XColor::C341,    XColor::C342,   XColor::C322,   XColor::C343,   XColor::C353,   XColor::C323,   XColor::C344,   XColor::C352,
    XColor::C320,    XColor::C345,   XColor::C351,   XColor::C321,   XColor::C335,   XColor::C350,   XColor::C334,   XColor::C324,
    XColor::C355,    XColor::C325,   XColor::C331,   XColor::C354,   XColor::C330,   XColor::C333,   XColor::C332,   XColor::C410,
    XColor::C411,    XColor::C412,   XColor::C413,   XColor::C403,   XColor::C414,   XColor::C402,   XColor::C415,   XColor::C401,
    XColor::C400,    XColor::C434,   XColor::C405,   XColor::C435,   XColor::C404,   XColor::C432,   XColor::C433,   XColor::C544,
    XColor::C430,    XColor::C545,   XColor::C431,   XColor::C542,   XColor::C543,   XColor::C540,   XColor::C541,   XColor::C551,
    XColor::C550,    XColor::C553,   XColor::C552,   XColor::C524,   XColor::C555,   XColor::C525,   XColor::C554,   XColor::C520,
    XColor::White,   XColor::C521,   XColor::C535,   XColor::C522,   XColor::C534,   XColor::C523,   XColor::C533,   XColor::C532,
    XColor::C531,    XColor::C530,   XColor::Cyan,   XColor::C032,   XColor::C033,   XColor::Purple, XColor::C030,   XColor::C031,
};
}  // namespace

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      名前のハッシュ値からXColorを取得
 *  \param[in]  hash    名前のハッシュ値（小文字のみ）
 *  \return     対応するXColor（オプショナル）
 */
/* ------------------------------------------------------------------------- */
std::optional<XColor> GetXColor(uint32_t hash) noexcept
{
    size_t min = 0;
    size_t max = 255;

    do
    {
        const size_t index = min + ((max - min) / 2);
        auto value = kNameHashTable[index];

        if (value == hash)
        {
            return kNameHashColorTable[index];
        }

        if (value > hash)
        {
            max = index;
        }
        else if (value < hash)
        {
            min = index + 1;
        }

    } while (min != max);

    return std::nullopt;
}
}    // namespace MGL
// vim: et ts=4 sw=4 sts=4
