// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_audio.cc
 *  \brief      MGL オーディオ
 *  \date       Since: October 28, 2022. 23:56:08 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#include <mgl/audio/mgl_audio.h>

namespace MGL::Audio
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ボイスの破棄
 *  \param[in]  key         破棄するボイスのキー
 *  \retval     true        成功
 *  \retval     false       失敗
 */
/* ------------------------------------------------------------------------- */
bool UnloadVoice(VoiceKey key) noexcept
{
    return Player::GetInstance().Unload(key);
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      マスター音量の設定
 *  \param[in]  volume  設定する音量
 */
/* ------------------------------------------------------------------------- */
void SetMasterVolume(float volume) noexcept
{
    Player::GetInstance().SetMasterVolume(volume);
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      マスター音量の取得
 *  \return     現在のマスター音量
 */
/* ------------------------------------------------------------------------- */
float GetMasterVolume() noexcept
{
    return Player::GetInstance().GetMasterVolume();
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ボイスのボリュームを設定
 *  \param[in]  voiceKey        ボイスキー
 *  \param[in]  volume          ボリューム
 */
/* ------------------------------------------------------------------------- */
void SetVoiceVolume(VoiceKey voiceKey, float volume) noexcept
{
    Player::GetInstance().SetVoiceVolume(voiceKey, volume);
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ボイスのボリュームを取得
 *  \param[in]  voiceKey        ボイスキー
 *  \return     ボイスのボリューム．無効なボイスキーを指定した場合は0.0f
 */
/* ------------------------------------------------------------------------- */
float GetVoiceVolume(VoiceKey voiceKey) noexcept
{
    return Player::GetInstance().GetVoiceVolume(voiceKey);
}

}    // namespace MGL::Audio

// vim: et ts=4 sw=4 sts=4
