// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_ui_event_listener.h
 *  \brief      MGL UIイベントリスナー
 *  \date       Since: July 7, 2023. 10:56:37 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_UI_EVENT_LISTENER_H_1688694997
#define INCGUARD_MGL_UI_EVENT_LISTENER_H_1688694997

#include <mgl/ui/mgl_ui_event_defs.h>

namespace MGL::UI
{

//! イベントリスナーインターフェース
class EventListener
{
public:
    virtual ~EventListener() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      イベント受信時のコールバック処理
     */
    /* ------------------------------------------------------------------------- */
    virtual void OnReceiveUIEvent(const EventResult &result) noexcept = 0;
};

}    // namespace MGL::UI

#endif    // INCGUARD_MGL_UI_EVENT_LISTENER_H_1688694997

// vim: et ts=4 sw=4 sts=4
