// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_ui_event_delegate.h
 *  \brief      MGL UIイベントデリゲート
 *  \date       Since: July 8, 2023. 13:14:01 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_UI_EVENT_DELEGATE_H_1688789641
#define INCGUARD_MGL_UI_EVENT_DELEGATE_H_1688789641

#include <mgl/stl/mgl_stl_containers.h>
#include <mgl/ui/mgl_ui_event_defs.h>

namespace MGL::UI
{
class EventDelegate
{
public:
    virtual ~EventDelegate() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      UIイベントの更新処理
     *  \param[in]  targets         イベント対象のUIウィジット
     *  \param[in]  currentFocusID  現在フォーカス中のウィジットのイベントID
     *  \return     イベント更新結果
     */
    /* ------------------------------------------------------------------------- */
    virtual EventResult OnUpdateUIEvent(const MGL::STL::vector<EventTarget> &targets, EventID currentFocusID) noexcept = 0;
};
}    // namespace MGL::UI

#endif    // INCGUARD_MGL_UI_EVENT_DELEGATE_H_1688789641

// vim: et ts=4 sw=4 sts=4
