// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_ui_event_context.h
 *  \brief      MGL UIイベントコンテキスト
 *  \date       Since: July 7, 2023. 10:54:26 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_UI_EVENT_CONTEXT_H_1688694866
#define INCGUARD_MGL_UI_EVENT_CONTEXT_H_1688694866

#include <mgl/stl/mgl_stl_containers.h>
#include <mgl/ui/mgl_ui_event_default_delegate.h>
#include <mgl/ui/mgl_ui_event_defs.h>

namespace MGL::UI
{
class EventListener;
class EventDelegate;

class EventContext
{
public:
    EventContext(EventListener *listener) noexcept;
    EventContext(EventListener *listener, EventDelegate *delegate) noexcept;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      イベント対象のクリア
     */
    /* ------------------------------------------------------------------------- */
    void ClearTargets() noexcept
    {
        _targets.clear();
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      イベント対象を追加
     *  \param[in]  target  イベント対象
     */
    /* ------------------------------------------------------------------------- */
    void AddTarget(const EventTarget &target) noexcept
    {
        _targets.push_back(target);
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      イベント対象を取得
     *  \return     イベント対象
     */
    /* ------------------------------------------------------------------------- */
    constexpr MGL::STL::vector<EventTarget> &GetTargets() noexcept
    {
        return _targets;
    }

    EventResult Update() noexcept;

    void SendEvent(const EventResult &result) noexcept;

private:
    EventListener *_listener;
    EventDelegate *_delegate;
    EventID _focusID{kInvalidEventID};
    MGL::STL::vector<EventTarget> _targets;
    DefaultEventDelegate _defaultDelegate;
};
}    // namespace MGL::UI

#endif    // INCGUARD_MGL_UI_EVENT_CONTEXT_H_1688694866

// vim: et ts=4 sw=4 sts=4
