/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_text_format_options.h
 *  \brief      MGL テキストフォーマットのオプション
 *  \date       Since: May 19, 2024. 3:48:14 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TEXT_FORMAT_OPTIONS_H_1716058094
#define INCGUARD_MGL_TEXT_FORMAT_OPTIONS_H_1716058094

#include <cstdint>

namespace MGL::Text
{
//! フォーマットオプション
struct FormatOptions
{
    //! 値の表示モード
    enum class ValueDisplayMode : uint8_t
    {
        Decimal,         //!< 10進数（デフォルト）
        UpperCaseHex,    //!< 大文字の16進数
        LowerCaseHex     //!< 小文字の16進数
    };

    bool isValid{false};                                             //!< オプションの有効フラグ
    int index{-1};                                                   //!< インデックス
    int width{0};                                                    //!< 表示幅（負数で左寄せ）
    int precision{-1};                                               //!< 小数点以下の表示桁数
    bool showSeparator{false};                                       //!< 区切り文字を表示
    bool showPlusSign{false};                                        //!< 正の数にも符号を表示
    char fillCharacter{' '};                                         //!< 表示幅を指定した際に埋める文字の指定
    bool skipAutoIndex{false};                                       //!< インデックスの自動カウントをスキップ
    ValueDisplayMode valueDisplayMode{ValueDisplayMode::Decimal};    //!< 値の表示モード
    int hexWidth{0};                                                 //!< 16進数の表示桁数
};
}    // namespace MGL::Text

#endif    // INCGUARD_MGL_TEXT_FORMAT_OPTIONS_H_1716058094

// vim: et ts=4 sw=4 sts=4
