// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_text_format.h
 *  \brief      MGL テキストフォーマット
 *  \date       Since: May 29, 2021. 15:24:20 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TEXT_FORMAT_H_1622269460
#define INCGUARD_MGL_TEXT_FORMAT_H_1622269460

#include <mgl/stl/mgl_stl_containers.h>
#include <mgl/stl/mgl_stl_string.h>
#include <mgl/text/mgl_text_defs.h>
#include <mgl/text/mgl_text_format_argument.h>
#include <mgl/text/mgl_text_index_converter.h>


namespace MGL::Text
{
STL::string Format(const STL::string &text, const FormatArgs &args) noexcept;
STL::vector<IndexedCharacter> Format(const IndexedCharacter *indexedText, const IndexConverter &indexConverter, const FormatArgs &args) noexcept;

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      文字列のフォーマット
 *  \param[in]  text    変換元の文字列
 *  \param[in]  args    引数
 *  \return     変換後の文字列
 */
/* ------------------------------------------------------------------------- */
template<class... Args>
STL::string Format(const STL::string &text, const Args &...args) noexcept
{
    return Format(text, {args...});
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      インデックス文字列のフォーマット
 *  \param[in]  indexedText     変換元のインデックス文字列
 *  \param[in]  indexConverter  引数の文字列をインデックス化するためのコンバータ
 *  \param[in]  args            引数
 *  \return     変換後のインデックス文字列
 */
/* ------------------------------------------------------------------------- */
template<class... Args>
STL::vector<IndexedCharacter> Format(const IndexedCharacter *indexedText, const IndexConverter &indexConverter, const Args &...args) noexcept
{
    return Format(indexedText, indexConverter, {args...});
}

}    // namespace MGL::Text

#endif    // INCGUARD_MGL_TEXT_FORMAT_H_1622269460

// vim: et ts=4 sw=4 sts=4
