// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_text_converter.h
 *  \brief      MGL テキストコンバータ
 *  \date       Since: June 29, 2022. 1:15:14 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TEXT_CONVERTER_H_1656432914
#define INCGUARD_MGL_TEXT_CONVERTER_H_1656432914

#include <mgl/stl/mgl_stl_string.h>
#include <mgl/text/mgl_text_defs.h>

namespace MGL::Text
{
bool ToUTF8(STL::string &dest, const void *src, size_t size, Encoding encoding, bool existBOM = false) noexcept;
bool ToUTF8(char *dest, size_t destSize, const void *src, size_t srcSize, Encoding encoding, bool existBOM = false) noexcept;
}    // namespace MGL::Text

#endif    // INCGUARD_MGL_TEXT_CONVERTER_H_1656432914

// vim: et ts=4 sw=4 sts=4
