/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_task_node_list_element.h
 *  \brief      MGL タスクリストのノード要素
 *  \date       Since: March 30, 2023. 17:43:08 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TASK_NODE_LIST_ELEMENT_H_1680165788
#define INCGUARD_MGL_TASK_NODE_LIST_ELEMENT_H_1680165788

#include <mgl/task/mgl_task_node.h>

namespace MGL::Task
{
//! ノードの要素
struct NodeListElement
{
    STL::unique_ptr<Node> node{nullptr};                     //!< このノード
    NodeListElement *next{nullptr};                          //!< 次のノード
    NodeListElement *previous{nullptr};                      //!< 前のノード
    UniqueIdentifier uniqueID{UniqueIdentifier::Invalid};    //!< ユニークID
    size_t arrayIndex{0};                                    //!< 配列上のインデックス
};
}    // namespace MGL::Task

#endif    // INCGUARD_MGL_TASK_NODE_LIST_ELEMENT_H_1680165788

// vim: et ts=4 sw=4 sts=4
