// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_window_module_win32.h
 *  \brief      MGL Win32用ウィンドウモジュール
 *  \date       Since: March 29, 2021. 16:56:37 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_WINDOW_MODULE_WIN32_H_1617004597
#define INCGUARD_MGL_WINDOW_MODULE_WIN32_H_1617004597

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_WIN32)

#include <mgl/system/window/mgl_window_module_interface.h>

namespace MGL::System
{
//! Win32用ウィンドウモジュール
class Win32WindowModule : public WindowModuleInterface
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ウィンドウ機能が有効かを取得
     *  \retval     true    有効
     *  \retval     false   無効
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailable() const noexcept override
    {
        return true;
    }

    void Resize(uint32_t width, uint32_t height) noexcept override;

    void SetFullscreen(bool isEnabled) noexcept override;
    void ToggleFullscreen() noexcept override;
    [[nodiscard]] bool IsFullscreen() const noexcept override;
    
    void Focus() noexcept override;
    [[nodiscard]] bool IsFocused() const noexcept override;

    void Alert(const char *message) const noexcept override;

    void SetTitle(const char *title) noexcept override;

    [[nodiscard]] int32_t GetIdentifier() const noexcept override;

    [[nodiscard]] ScreenSize GetScreenSize() const noexcept override;
};
}   // namespace MGL::System

#endif  // MGL_TARGET_WIN32
#endif	// INCGUARD_MGL_WINDOW_MODULE_WIN32_H_1617004597

// vim: et ts=4 sw=4 sts=4
