// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_window_module_macos.h
 *  \brief      MGL macOS用ウィンドウ制御
 *  \date       Since: February 19, 2021. 15:16:59 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_WINDOW_MODULE_MACOS_H_1613715419
#define INCGUARD_MGL_WINDOW_MODULE_MACOS_H_1613715419

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_MACOS)

#include <mgl/system/window/mgl_window_module_interface.h>
#include <mgl/event/mgl_event.h>

namespace MGL::System
{
//! macOS用ウィンドウ制御クラス
class MacOSWindowModule : public WindowModuleInterface
{
public:
    MacOSWindowModule() noexcept;

    [[nodiscard]] bool IsAvailable() const noexcept override
    {
        return true;
    }
    
    void Resize(uint32_t width, uint32_t height) noexcept override;

    void SetFullscreen(bool isEnabled) noexcept override;
    void ToggleFullscreen() noexcept override;
    [[nodiscard]] bool IsFullscreen() const noexcept override;
    
    void Focus() noexcept override;
    [[nodiscard]] bool IsFocused() const noexcept override;

    void Alert(const char *message) const noexcept override;

    void SetTitle(const char *title) noexcept override;
    
    [[nodiscard]] int32_t GetIdentifier() const noexcept override;

    [[nodiscard]] ScreenSize GetScreenSize() const noexcept override;
};
}   // namespace MGL::System

#endif  // MGL_TARGET_MACOS
#endif	// INCGUARD_MGL_WINDOW_MODULE_MACOS_H_1613715419

// vim: et ts=4 sw=4 sts=4
