// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_window_module_default.h
 *  \brief      MGL ウィンドウ機能のデフォルト動作
 *  \date       Since: February 19, 2021. 18:14:09 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_WINDOW_MODULE_DEFAULT_H_1613726049
#define INCGUARD_MGL_WINDOW_MODULE_DEFAULT_H_1613726049

#include <mgl/system/window/mgl_window_module_interface.h>

namespace MGL::System
{
//! ウィンドウ機能のデフォルト動作クラス
class DefaultWindowModule : public WindowModuleInterface
{
public:
    DefaultWindowModule() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ウィンドウ機能が有効かを取得
     *  \retval     true    有効
     *  \retval     false   無効
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailable() const noexcept override { return false; }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      サイズの変更
     *  \param[in]  width   幅
     *  \param[in]  height  高さ
     */
    /* ------------------------------------------------------------------------- */
    void Resize([[maybe_unused]] uint32_t width, [[maybe_unused]] uint32_t height) noexcept override {}

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      フルスクリーンの設定
     *  \param[in]  isEnabled   有効フラグ
     */
    /* ------------------------------------------------------------------------- */
    void SetFullscreen([[maybe_unused]] bool isEnabled) noexcept override {}

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      フルスクリーンの有効・無効の切り替え
     */
    /* ------------------------------------------------------------------------- */
    void ToggleFullscreen() noexcept override {}

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      フルスクリーン状態の取得
     *  \retval     true    フクスクリーン
     *  \retval     false   ウィンドウ
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsFullscreen() const noexcept override { return true; }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ウィンドウにフォーカスを設定
     *  \note       フォーカス = macOSでいうキーウィンドウ，Windowsでいうアクティブウィンドウ
     */
    /* ------------------------------------------------------------------------- */
    void Focus() noexcept override {}

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      フォーカス状態の取得
     *  \retval     true    フォーカス
     *  \retval     false   フォーカスでない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsFocused() const noexcept override { return true; }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アラートの表示
     *  \param[in]  message     表示メッセージ
     */
    /* ------------------------------------------------------------------------- */
    void Alert([[maybe_unused]] const char *message) const noexcept override {}

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ウィンドウタイトルの設定
     *  \param[in]  title   設定するウィンドウタイトル
     */
    /* ------------------------------------------------------------------------- */
    void SetTitle([[maybe_unused]] const char *title) noexcept override {}

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ウィンドウの識別子を取得
     *  \return     ウィンドウの識別子
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] int32_t GetIdentifier() const noexcept override { return 0; }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ウィンドウが存在している画面のサイズ情報を取得
     *  \return     画面サイズ
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] ScreenSize GetScreenSize() const noexcept override { return {}; }
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_WINDOW_MODULE_DEFAULT_H_1613726049

// vim: et ts=4 sw=4 sts=4
