// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_system_defs.h
 *  \brief      MGL システム関連の共通定義
 *  \date       Since: June 23, 2022. 19:43:14 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_SYSTEM_DEFS_H_1655980994
#define INCGUARD_MGL_SYSTEM_DEFS_H_1655980994

#include <mgl/math/mgl_vector2.h>

namespace MGL::System
{
//! 画面サイズ情報
struct ScreenSize
{
    bool isAvailable{false};    //!< 情報が有効かを取得

    MGL::Vector2 physicalSize;    //!< 物理サイズ（実際に出力されるサイズ）
    MGL::Vector2 logicalSize;     //!< 論理サイズ（UI等が利用する疑似的なサイズ）
    MGL::Vector2 backingSize;     //!< 内部サイズ（GPUが画面全体を表現するために利用しているサイズ）
};

}    // namespace MGL::System

#endif    // INCGUARD_MGL_SYSTEM_DEFS_H_1655980994

// vim: et ts=4 sw=4 sts=4
