// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_system_debug_macro.h
 *  \brief      MGL デバッグ用マクロ
 *  \date       Since: February 25, 2021. 11:56:01 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_SYSTEM_DEBUG_MACRO_H_1614221761
#define INCGUARD_MGL_SYSTEM_DEBUG_MACRO_H_1614221761

#include <mgl/mgl_environment.h>
#include <mgl/system/mgl_system_module_set.h>

#if defined(MGL_DEBUG)

//! ログ出力マクロ
#define MGL_LOG(logLevel, ...)                                                             \
    do                                                                                     \
    {                                                                                      \
        MGL::System::ModuleSet::GetInstance().GetDebugModule().Log(logLevel, __VA_ARGS__); \
    } while (0)

//! エラーログ出力マクロ
#define MGL_ERROR(...)                                      \
    do                                                      \
    {                                                       \
        MGL_LOG(MGL::System::LogLevel::Error, __VA_ARGS__); \
    } while (0)

//! 警告ログ出力マクロ
#define MGL_WARNING(...)                                      \
    do                                                        \
    {                                                         \
        MGL_LOG(MGL::System::LogLevel::Warning, __VA_ARGS__); \
    } while (0)

//! トレース出力マクロ
#define MGL_TRACE(...)                                         \
    do                                                         \
    {                                                          \
        MGL_LOG(MGL::System::LogLevel::AppTrace, __VA_ARGS__); \
    } while (0)

//! ライブラリ用トレース出力マクロ
#define MGL_LIBRARY_TRACE(...)                                     \
    do                                                             \
    {                                                              \
        MGL_LOG(MGL::System::LogLevel::LibraryTrace, __VA_ARGS__); \
    } while (0)

//! トラップ用マクロ
#define MGL_TRAP()                                                     \
    do                                                                 \
    {                                                                  \
        MGL::System::ModuleSet::GetInstance().GetDebugModule().Trap(); \
    } while (0)

//! アボート用マクロ
#define MGL_ABORT()                                                     \
    do                                                                  \
    {                                                                   \
        MGL::System::ModuleSet::GetInstance().GetDebugModule().Abort(); \
    } while (0)

//! アサート用マクロ
#define MGL_ASSERT(expr, ...)                                                 \
    do                                                                        \
    {                                                                         \
        if (!(expr))                                                          \
        {                                                                     \
            MGL_ERROR("[ASSERT] %s:%d\n%s", __FILE__, __LINE__, __VA_ARGS__); \
            MGL_ABORT();                                                      \
        }                                                                     \
    } while (0)

#else

#define MGL_LOG(...) ((void)0)              //!< ログ出力マクロ
#define MGL_ERROR(...) ((void)0)            //!< エラーログ出力マクロ
#define MGL_WARNING(...) ((void)0)          //!< 警告ログ出力マクロ
#define MGL_TRACE(...) ((void)0)            //!< トレース出力マクロ
#define MGL_LIBRARY_TRACE(...) ((void)0)    //!< ライブラリ用トレース出力マクロ
#define MGL_TRAP(...) ((void)0)             //!< トラップ用マクロ
#define MGL_ABORT(...) ((void)0)            //!< アボート用マクロ
#define MGL_ASSERT(...) ((void)0)           //!< アサート用マクロ

#endif

#endif    // INCGUARD_MGL_SYSTEM_DEBUG_MACRO_H_1614221761

// vim: et ts=4 sw=4 sts=4
