// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_locale_module_win32.h
 *  \brief      MGL Win32用ロケール情報モジュール
 *  \date       Since: March 29, 2021. 17:44:48 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_LOCALE_MODULE_WIN32_H_1617007488
#define INCGUARD_MGL_LOCALE_MODULE_WIN32_H_1617007488

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_WIN32)

#include <mgl/system/locale/mgl_locale_module_interface.h>

namespace MGL::System
{
//! Win32用ロケール情報モジュール
class Win32LocaleModule : public LocaleModuleInterface
{
public:
    Win32LocaleModule() noexcept;

    void Initialize() noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ロケール情報を取得
     *  \return     現在のロケール情報
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] LocaleInfo &GetLocaleInfo() noexcept override
    {
        return _currentInfo;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      デフォルトのロケール情報を取得
     *  \return     デフォルトのロケール情報
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] const LocaleInfo &GetDefaultLocaleInfo() const noexcept override
    {
        return _defaultInfo;
    }

private:
    LocaleInfo _currentInfo;
    LocaleInfo _defaultInfo;
};
}    // namespace MGL::System

#endif    // MGL_TARGET_WIN32
#endif    // INCGUARD_MGL_LOCALE_MODULE_WIN32_H_1617007488

// vim: et ts=4 sw=4 sts=4
