// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_locale_module_interface.h
 *  \brief      MGL ロケール情報モジュールのインターフェース
 *  \date       Since: February 23, 2021. 9:31:04 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_LOCALE_MODULE_INTERFACE_H_1614040264
#define INCGUARD_MGL_LOCALE_MODULE_INTERFACE_H_1614040264

#include <mgl/system/locale/mgl_locale_info.h>

namespace MGL::System
{
//! ローケール情報モジュールのインターフェース
class LocaleModuleInterface
{
public:
    virtual ~LocaleModuleInterface() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      初期化
     */
    /* ------------------------------------------------------------------------- */
    virtual void Initialize() noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ロケール情報を取得
     *  \return     現在のロケール情報
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual LocaleInfo &GetLocaleInfo() noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      デフォルトのロケール情報を取得
     *  \return     デフォルトのロケール情報
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual const LocaleInfo &GetDefaultLocaleInfo() const noexcept = 0;
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_LOCALE_MODULE_INTERFACE_H_1614040264

// vim: et ts=4 sw=4 sts=4
