// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_locale_module_default.h
 *  \brief      MGL デフォルトのロケール情報モジュール
 *  \date       Since: February 24, 2021. 1:49:04 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_LOCALE_MODULE_DEFAULT_H_1614098944
#define INCGUARD_MGL_LOCALE_MODULE_DEFAULT_H_1614098944

#include <mgl/system/locale/mgl_locale_module_interface.h>

namespace MGL::System
{
//! デフォルトのロケール情報モジュール
class DefaultLocaleModule : public LocaleModuleInterface
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     */
    /* ------------------------------------------------------------------------- */
    DefaultLocaleModule() noexcept
        : _currentInfo()
        , _defaultInfo()
    {
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      初期化
     */
    /* ------------------------------------------------------------------------- */
    void Initialize() noexcept override
    {
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ロケール情報を取得
     *  \return     現在のロケール情報
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] LocaleInfo &GetLocaleInfo() noexcept override
    {
        return _currentInfo;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      デフォルトのロケール情報を取得
     *  \return     デフォルトのロケール情報
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] const LocaleInfo &GetDefaultLocaleInfo() const noexcept override
    {
        return _defaultInfo;
    }

private:
    LocaleInfo _currentInfo;
    LocaleInfo _defaultInfo;
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_LOCALE_MODULE_DEFAULT_H_1614098944

// vim: et ts=4 sw=4 sts=4
