// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_locale_module_apple.h
 *  \brief      MGL Apple（macOS/iOS/tvOS）ロケール情報モジュール
 *  \date       Since: February 23, 2021. 11:19:42 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_LOCALE_MODULE_APPLE_H_1614046782
#define INCGUARD_MGL_LOCALE_MODULE_APPLE_H_1614046782

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)

#include <mgl/system/locale/mgl_locale_module_interface.h>

namespace MGL::System
{
//! Apple（macOS/iOS/tvOS）ロケール情報モジュール
class AppleLocaleModule : public LocaleModuleInterface
{
public:
    AppleLocaleModule() noexcept;

    void Initialize() noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ロケール情報を取得
     *  \return     現在のロケール情報
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] LocaleInfo &GetLocaleInfo() noexcept override
    {
        return _currentInfo;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      デフォルトのロケール情報を取得
     *  \return     デフォルトのロケール情報
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] const LocaleInfo &GetDefaultLocaleInfo() const noexcept override
    {
        return _defaultInfo;
    }

private:
    LocaleInfo _currentInfo;
    LocaleInfo _defaultInfo;
};
}    // namespace MGL::System

#endif    // defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)
#endif    // INCGUARD_MGL_LOCALE_MODULE_APPLE_H_1614046782

// vim: et ts=4 sw=4 sts=4
