// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_locale_info.h
 *  \brief      MGL ロケール情報の定義
 *  \date       Since: February 23, 2021. 9:47:51 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_LOCALE_INFO_H_1614041271
#define INCGUARD_MGL_LOCALE_INFO_H_1614041271

#include <cstdint>

#include <mgl/stl/mgl_stl_string.h>

namespace MGL::System
{
//! 言語
enum class Language : uint32_t
{
    Unknown,                //!< 不明
    Arabic,                 //!< アラビア語
    BrazilPortuguese,       //!< ブラジルポルトガル語
    Bulgarian,              //!< ブルガリア語
    Czech,                  //!< チェコ語
    Dansk,                  //!< デンマーク語
    Deutsch,                //!< ドイツ語
    English,                //!< 英語
    French,                 //!< フランス語
    Greek,                  //!< ギリシャ語
    Italiano,               //!< イタリア語
    Japanese,               //!< 日本語
    Korean,                 //!< 韓国語
    LatinAmericaSpanish,    //!< ラテンアメリカのスペイン語
    Magyar,                 //!< ハンガリー語
    Nederlands,             //!< オランダ語
    Norsk,                  //!< ノルウェー語
    Polski,                 //!< ポーランド語
    Portuguese,             //!< ポルトガル語
    Romanian,               //!< ルーマニア語
    Russian,                //!< ロシア語
    SimplifiedChinese,      //!< 簡体中文
    Spanish,                //!< スペイン語
    Suomi,                  //!< フィンランド語
    Svenska,                //!< スウェーデン語
    Thai,                   //!< タイ語
    TraditionalChinese,     //!< 繁体中文
    Turkish,                //!< トルコ語
    Ukrainian,              //!< ウクライナ語
    Vietnamese,             //!< ベトナム語

    Invalid = 0xFFFFFFFF    //!< 無効な言語
};

//! ロケール情報
struct LocaleInfo
{
    Language language{Language::Unknown};    //!< 言語
    int32_t timeDifference{0};               //!< UTC基準の時差
    uint8_t groupingSize{3};                 //!< 区切り桁数
    STL::string groupingSeparator{","};      //!< 桁区切り記号
    STL::string decimalSeparator{"."};       //!< 小数点記号
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_LOCALE_INFO_H_1614041271

// vim: et ts=4 sw=4 sts=4
