// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_debug_module_win32.h
 *  \brief      MGL Win32用モジュール
 *  \date       Since: March 29, 2021. 16:06:07 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_DEBUG_MODULE_WIN32_H_1617001567
#define INCGUARD_MGL_DEBUG_MODULE_WIN32_H_1617001567

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_WIN32)

#include <mgl/system/debug/mgl_debug_module_interface.h>

namespace MGL::System
{
//! Win32用デバッグモジュール
class Win32DebugModule : public DebugModuleInterface
{
public:
    Win32DebugModule(LogLevel logLevel) noexcept;

    void Log(LogLevel logLevel, const char *format, ...) const noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ログレベルを設定
     *  \param[in]  logLevel    ログレベル
     */
    /* ------------------------------------------------------------------------- */
    void SetLogLevel(LogLevel logLevel) noexcept override
    {
        _logLevel = logLevel;
    }

    void Trap() const noexcept override;
    void Abort() const noexcept override;

private:
    LogLevel _logLevel;
};
}    // namespace MGL::System

#endif    // MGL_TARGET_WIN32
#endif    // INCGUARD_MGL_DEBUG_MODULE_WIN32_H_1617001567

// vim: et ts=4 sw=4 sts=4
