// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_debug_module_interface.h
 *  \brief      MGL デバッグモジュールインターフェース
 *  \date       Since: February 25, 2021. 11:20:12 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_DEBUG_MODULE_INTERFACE_H_1614219612
#define INCGUARD_MGL_DEBUG_MODULE_INTERFACE_H_1614219612

#include <mgl/system/debug/mgl_debug_log_level.h>

namespace MGL::System
{
//! MGL デバッグモジュールインターフェース
class DebugModuleInterface
{
public:
    virtual ~DebugModuleInterface() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ログ出力
     *  \param[in]  logLevel    ログレベル
     *  \param[in]  format      フォーマット文字列
     */
    /* ------------------------------------------------------------------------- */
    virtual void Log(LogLevel logLevel, const char *format, ...) const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ログレベルを設定
     *  \param[in]  logLevel    ログレベル
     */
    /* ------------------------------------------------------------------------- */
    virtual void SetLogLevel(LogLevel logLevel) noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      プログラムの中断（再開可能）
     */
    /* ------------------------------------------------------------------------- */
    virtual void Trap() const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      プログラムの中断（再開不可）
     */
    /* ------------------------------------------------------------------------- */
    virtual void Abort() const noexcept = 0;
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_DEBUG_MODULE_INTERFACE_H_1614219612

// vim: et ts=4 sw=4 sts=4
