// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_debug_module_default.h
 *  \brief      MGL デフォルトのデバッグモジュール
 *  \date       Since: February 25, 2021. 11:45:50 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_DEBUG_MODULE_DEFAULT_H_1614221150
#define INCGUARD_MGL_DEBUG_MODULE_DEFAULT_H_1614221150

#include <mgl/system/debug/mgl_debug_module_interface.h>

namespace MGL::System
{
//! デフォルトのデバッグモジュール
class DefaultDebugModule : public DebugModuleInterface
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     *  \param[in]  logLevel    ログレベル
     */
    /* ------------------------------------------------------------------------- */
    DefaultDebugModule([[maybe_unused]] LogLevel logLevel) noexcept {};

    // NOLINTBEGIN(modernize-avoid-variadic-functions)
    // Note: ログ出力関数はprintf()のフォーマットに似せているため無効化する。似せる必要があるかは要再検討。
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ログ出力
     *  \param[in]  logLevel    ログレベル
     *  \param[in]  format      フォーマット文字列
     */
    /* ------------------------------------------------------------------------- */
    void Log([[maybe_unused]] LogLevel logLevel, [[maybe_unused]] const char *format, ...) const noexcept override
    {
    }
    // NOLINTEND(modernize-avoid-variadic-functions)

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ログレベルを設定
     *  \param[in]  logLevel    ログレベル
     */
    /* ------------------------------------------------------------------------- */
    void SetLogLevel([[maybe_unused]] LogLevel logLevel) noexcept override
    {
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      プログラムの中断（再開可能）
     */
    /* ------------------------------------------------------------------------- */
    void Trap() const noexcept override
    {
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      プログラムの中断（再開不可）
     */
    /* ------------------------------------------------------------------------- */
    void Abort() const noexcept override
    {
    }
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_DEBUG_MODULE_DEFAULT_H_1614221150

// vim: et ts=4 sw=4 sts=4
