// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_debug_module_apple.h
 *  \brief      MGL Apple用デバッグモジュール
 *  \date       Since: February 25, 2021. 11:29:51 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_DEBUG_MODULE_APPLE_H_1614220191
#define INCGUARD_MGL_DEBUG_MODULE_APPLE_H_1614220191

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)

#include <mgl/system/debug/mgl_debug_module_interface.h>

namespace MGL::System
{
//! Apple用デバッグモジュール
class AppleDebugModule : public DebugModuleInterface
{
public:
    AppleDebugModule(LogLevel logLevel) noexcept;

    void Log(LogLevel logLevel, const char *format, ...) const noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ログレベルを設定
     *  \param[in]  logLevel    ログレベル
     */
    /* ------------------------------------------------------------------------- */
    void SetLogLevel(LogLevel logLevel) noexcept override
    {
        _logLevel = logLevel;
    }

    void Trap() const noexcept override;
    void Abort() const noexcept override;

private:
    LogLevel _logLevel;
};
}    // namespace MGL::System

#endif    // defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)
#endif    // INCGUARD_MGL_DEBUG_MODULE_APPLE_H_1614220191

// vim: et ts=4 sw=4 sts=4
