// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_debug_log_level.h
 *  \brief      MGL デバッグ用ログレベル定義
 *  \date       Since: March 18, 2021. 18:19:58 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_DEBUG_LOG_LEVEL_H_1616059198
#define INCGUARD_MGL_DEBUG_LOG_LEVEL_H_1616059198

#include <cstdint>

namespace MGL::System
{
//! ログレベル
enum class LogLevel : uint8_t
{
    Error,           //!< エラー
    Warning,         //!< 警告
    AppTrace,        //!< アプリケーション側のトレース
    LibraryTrace,    //!< ライブラリ側のトレース
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_DEBUG_LOG_LEVEL_H_1616059198

// vim: et ts=4 sw=4 sts=4
