// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_chrono_module_win32.h
 *  \brief      MGL Win32用の日付と時刻のモジュール
 *  \date       Since: March 29, 2021. 18:18:50 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_CHRONO_MODULE_WIN32_H_1617009530
#define INCGUARD_MGL_CHRONO_MODULE_WIN32_H_1617009530

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_WIN32)

#include <mgl/system/chrono/mgl_chrono_module_interface.h>

namespace MGL::System
{
//! Win32用の日付と時間のモジュール
class Win32ChronoModule : public ChronoModuleInterface
{
public:
    [[nodiscard]] EpochTime GetCurrentEpochTime() const noexcept override;

    [[nodiscard]] bool IsAvailableTickTimer() const noexcept override;
    [[nodiscard]] TickTime GetTickTime() const noexcept override;
    [[nodiscard]] float TicksToNanoseconds(TickTime tickTime) const noexcept override;
};
}    // namespace MGL::System

#endif    // MGL_TARGET_WIN32
#endif    // INCGUARD_MGL_CHRONO_MODULE_WIN32_H_1617009530

// vim: et ts=4 sw=4 sts=4
