// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_chrono_module_interface.h
 *  \brief      MGL 日付と時間のモジュールインターフェース
 *  \date       Since: February 24, 2021. 4:17:41 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_CHRONO_MODULE_INTERFACE_H_1614107861
#define INCGUARD_MGL_CHRONO_MODULE_INTERFACE_H_1614107861

#include <mgl/system/chrono/mgl_chrono_defs.h>

namespace MGL::System
{
//! 日付と時間のモジュールインターフェース
class ChronoModuleInterface
{
public:
    virtual ~ChronoModuleInterface() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      現在時刻をエポック時間で取得
     *  \return     現在時刻
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual EpochTime GetCurrentEpochTime() const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      Tickタイマーに対応しているかを取得
     *  \retval     true    対応している
     *  \retval     false   対応していない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual bool IsAvailableTickTimer() const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      現在のTickTimeを取得
     *  \return     現在のTickTime
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual TickTime GetTickTime() const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      TickTimeをナノ秒に変換
     *  \return     変換後の時間
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual float TicksToNanoseconds(TickTime tickTime) const noexcept = 0;
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_CHRONO_MODULE_INTERFACE_H_1614107861

// vim: et ts=4 sw=4 sts=4
