// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_chrono_module_default.h
 *  \brief      MGL デフォルトの日付と時間のモジュール
 *  \date       Since: February 24, 2021. 4:50:34 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_CHRONO_MODULE_DEFAULT_H_1614109834
#define INCGUARD_MGL_CHRONO_MODULE_DEFAULT_H_1614109834

#include <mgl/system/chrono/mgl_chrono_module_interface.h>

namespace MGL::System
{
//! デフォルトの日付と時間のモジュール
class DefaultChronoModule : public ChronoModuleInterface
{
public:
    DefaultChronoModule() noexcept = default;

    [[nodiscard]] EpochTime GetCurrentEpochTime() const noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      Tickタイマーに対応しているかを取得
     *  \retval     true    対応している
     *  \retval     false   対応していない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailableTickTimer() const noexcept override
    {
        return false;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      現在のTickTimeを取得
     *  \return     現在のTickTime
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] TickTime GetTickTime() const noexcept override
    {
        return 0;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      TickTimeをナノ秒に変換
     *  \return     変換後の時間
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] float TicksToNanoseconds([[maybe_unused]] TickTime tickTime) const noexcept override
    {
        return 0.0f;
    }
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_CHRONO_MODULE_DEFAULT_H_1614109834

// vim: et ts=4 sw=4 sts=4
